﻿using System.Diagnostics;

class Program
{
    static void Main()
    {
        Random rand = new Random();

        // 1. basic test naplneni celeho autobusu
        BusStop busStop = new BusStop();

        List<Thread> threads = new List<Thread>();
        for (int i = 0; i < 10; i++)
        {
            threads.Add(new Thread(_ => busStop.PassengerArrive()));
        }
        threads.ForEach(t => t.Start());
        Thread.Sleep(500); // trochu hack :/

        // passengeri by nemeli nastoupit, dokud neprijede bus
        Debug.Assert(busStop.boardedCount == 0);

        busStop.BusArrive();

        // nastoupilo vsech 10 cestujicich a autobus odjel
        Debug.Assert(busStop.boardedCount == 10);
        Debug.Assert(busStop.busDepartedCount == 1);

        // 2. test castecnyho naplneni autobusu
        threads = new List<Thread>();
        for (int i = 0; i < 5; i++)
        {
            threads.Add(new Thread(_ => busStop.PassengerArrive()));
        }
        threads.ForEach(t => t.Start());
        Thread.Sleep(500); // trochu hack :/

        busStop.BusArrive();

        // autobus odjel poloprazdny
        Debug.Assert(busStop.boardedCount == 15);
        Debug.Assert(busStop.busDepartedCount == 2);

        // 3. autobus odjede prazdny kdyz tam nikdo neni
        busStop.BusArrive();

        // autobus odjel prazdny
        Debug.Assert(busStop.boardedCount == 15);
        Debug.Assert(busStop.busDepartedCount == 3);

        // 4. test spravne synchronizace busu
        // prijde 50 cestujicich
        threads = new List<Thread>();
        for (int i = 0; i < 50; i++)
        {
            threads.Add(new Thread(_ => busStop.PassengerArrive()));
        }
        threads.ForEach(t => t.Start());
        Thread.Sleep(1000); // trochu hack :/

        // prijede 5 busu
        threads = new List<Thread>();
        for (int i = 0; i < 5; i++)
        {
            threads.Add(new Thread(_ => busStop.BusArrive()));
        }
        threads.ForEach(t => t.Start());
        threads.ForEach(t => t.Join());

        // odjelo 5 plnych autobusu
        Debug.Assert(busStop.boardedCount == 65);
        Debug.Assert(busStop.busDepartedCount == 8);

        // 5. baraz random operacema
        threads = new List<Thread>();
        int seed = rand.Next();
        for (int i = 0; i < 10; i++)
        {
            threads.Add(new Thread(_ => DoRandomStuff(1000, seed + i, busStop)));
        }
        threads.ForEach(t => t.Start());
        threads.ForEach(t => t.Join());

        // 6. autobus neodveze vic nez 10 lidi
        BusStop busStop = new BusStop();

        List<Thread> threads = new List<Thread>();
        for (int i = 0; i < 20; i++)
        {
            threads.Add(new Thread(_ => busStop.PassengerArrive()));
        }
        threads.ForEach(t => t.Start());
        Thread.Sleep(1000); // trochu hack :/

        busStop.BusArrive();

        // nastoupilo vsech 10 cestujicich a autobus odjel
        Debug.Assert(busStop.boardedCount == 10);
        Debug.Assert(busStop.busDepartedCount == 1);
    }

    static void DoRandomStuff(int count, int seed, BusStop busStop)
    {
        Random rand = new Random(seed);

        for (int i = 0; i < count; i++)
        {
            if (rand.Next(10) == 0)
            {
                busStop.BusArrive();
            }
            else
            {
                var t = new Thread(_ => busStop.PassengerArrive());
                t.Start();
            }
        }
    }
}
