﻿using System.Diagnostics;

enum OpType
{
    ADD = 0, DELETE = 1, CONTAINS = 2
}

class Operation
{
    public OpType type;
    public int elem;

    public Operation(OpType type, int elem)
    {
        this.type = type;
        this.elem = elem;
    }
}

public class Program
{
    static Random rand = new Random();

    // Tento soubor obsahuje testy pro lokalni testovani
    public static void Main(string[] args)
    {
        MyHashTable hashTable = new MyHashTable(100);

        hashTable.Add(13);
        hashTable.Add(157);

        // spravna implementace contains
        Debug.Assert(hashTable.Contains(13));
        Debug.Assert(!hashTable.Contains(3));

        // test spravnyho odstranovani
        Debug.Assert(!hashTable.Delete(3));
        Debug.Assert(hashTable.Delete(13));

        // cislo se neprida dvakrat
        hashTable.Add(44);
        hashTable.Add(44);
        Debug.Assert(hashTable.Contains(44));
        Debug.Assert(hashTable.Delete(44));
        Debug.Assert(!hashTable.Contains(44));

        // baraz random operacema, ktera v pripade blby implementace muze zpusobit exceptiony
        for (int i = 0; i < 50; i++)
            RandomMultiThreadedOps(10, 10000);
    }

    static void RandomMultiThreadedOps(int threadCount, int opCount)
    {
        var hashTable = new MyHashTable(threadCount * opCount);
        Thread[] threads = new Thread[threadCount];

        for (int i = 0; i < threadCount; i++)
        {
            var ops = GenerateOperations(opCount);
            threads[i] = new Thread(() => RunOperations(ops, hashTable));
        }

        foreach (var thr in threads)
        {
            thr.Start();
        }

        foreach (var thr in threads)
        {
            thr.Join();
        }
    }

    static Operation[] GenerateOperations(int count)
    {
        Operation[] ops = new Operation[count];

        for (int i = 0; i < count; i++)
        {
            int type = Program.rand.Next(3);
            int num = Program.rand.Next();

            ops[i] = new Operation((OpType)type, num);
        }

        return ops;
    }

    static void RunOperations(Operation[] ops, MyHashTable myHashTable)
    {
        foreach (var op in ops)
        {
            switch (op.type)
            {
                case OpType.ADD:
                    myHashTable.Add(op.elem);
                    break;
                case OpType.CONTAINS:
                    myHashTable.Contains(op.elem);
                    break;
                case OpType.DELETE:
                    myHashTable.Delete(op.elem);
                    break;
            }
        }
    }
}
