﻿using System.Diagnostics;

public class Program
{

    // Tento soubor obsahuje testy pro lokalni testovani
    public static void Main(string[] args)
    {
        // 2 samotne procesy
        var mlfq = new MLFQ(3, [5, 5, 5], 100, 5);
        mlfq.add(new Process("A", 100));
        mlfq.add(new Process("B", 100));

        var toPlan = mlfq.planNext();
        Debug.Assert(toPlan == "A");
        mlfq.timeSliceFinished("A", 5);

        toPlan = mlfq.planNext();
        Debug.Assert(toPlan == "B");
        mlfq.timeSliceFinished("B", 5);

        toPlan = mlfq.planNext();
        Debug.Assert(toPlan == "A");
        mlfq.timeSliceFinished("A", 5);

        toPlan = mlfq.planNext();
        Debug.Assert(toPlan == "B");
        mlfq.timeSliceFinished("B", 5);

        // pridani kratkeho jobu pozdeji
        mlfq = new MLFQ(6, [1, 1, 1, 1, 1, 1], 100, 1);
        mlfq.add(new Process("A", 100));

        for (int x = 0; x < 6; x++)
        {
            toPlan = mlfq.planNext();
            Debug.Assert(toPlan == "A");
            mlfq.timeSliceFinished("A", 1);
        }

        mlfq.add(new Process("B", 5));

        for (int x = 0; x < 5; x++)
        {
            toPlan = mlfq.planNext();
            Debug.Assert(toPlan == "B");
            mlfq.timeSliceFinished("B", 1);
        }

        // pridani interaktivniho jobu pozdeji
        mlfq = new MLFQ(2, [10, 5], 100, 5);
        mlfq.add(new Process("A", 100));

        for (int x = 0; x < 2; x++)
        {
            toPlan = mlfq.planNext();
            Debug.Assert(toPlan == "A");
            mlfq.timeSliceFinished("A", 5);
        }

        mlfq.add(new Process("B", 100));

        for (int x = 0; x < 10; x++)
        {
            toPlan = mlfq.planNext();
            Debug.Assert(toPlan == "B");
            mlfq.timeSliceFinished("B", 1);
        }

        toPlan = mlfq.planNext();
        Debug.Assert(toPlan == "A");

        // test "boostu" priority
        mlfq = new MLFQ(2, [1, 1], 5, 1);
        mlfq.add(new Process("A", 100));

        toPlan = mlfq.planNext();
        Debug.Assert(toPlan == "A");
        mlfq.timeSliceFinished("A", 1);

        for (int x = 0; x < 4; x++)
        {
            mlfq.add(new Process("B", 1));
            toPlan = mlfq.planNext();
            Debug.Assert(toPlan == "B");
            mlfq.timeSliceFinished("B", 1);
        }

        mlfq.add(new Process("B", 1));
        toPlan = mlfq.planNext();
        Debug.Assert(toPlan == "A");
        mlfq.timeSliceFinished("A", 1);
    }
}
