﻿using System.Diagnostics;

public class Program
{
    public static bool DoubleEqual(double x, double y)
    {
        return Math.Abs(x - y) <= 1E-15;
    }

    // Tento soubor obsahuje testy pro lokalni testovani
    public static void Main(string[] args)
    {
        Planners planners = new Planners();

        // test jednoducheho SJF
        List<TimeSlice> plan1 = planners.planSJF([new Process("A", 30), new Process("B", 20), new Process("C", 10)]);
        Debug.Assert(plan1.SequenceEqual([new TimeSlice("C", 10), new TimeSlice("B", 20), new TimeSlice("A", 30)]));

        // test spravneho naplanovani SJF v pripade stejneho casu
        List<TimeSlice> plan2 = planners.planSJF([new Process("B", 20), new Process("A", 20), new Process("C", 10)]);
        Debug.Assert(plan2.SequenceEqual([new TimeSlice("C", 10), new TimeSlice("A", 20), new TimeSlice("B", 20)]));

        // test jednoducheho RR
        List<TimeSlice> plan3 = planners.planRR([new Process("A", 10), new Process("B", 10), new Process("C", 10)], 5);
        Debug.Assert(plan3.SequenceEqual([new TimeSlice("A", 5), new TimeSlice("B", 5), new TimeSlice("C", 5), new TimeSlice("A", 5), new TimeSlice("B", 5), new TimeSlice("C", 5)]));

        // test RR s ruznou delkou procesu
        List<TimeSlice> plan4 = planners.planRR([new Process("A", 20), new Process("B", 10)], 5);
        Debug.Assert(plan4.SequenceEqual([new TimeSlice("A", 5), new TimeSlice("B", 5), new TimeSlice("A", 5), new TimeSlice("B", 5), new TimeSlice("A", 10)]));

        // doba k dokonceni a odezva pro 1. plan
        double time1 = planners.calculateTurnaround(plan1);
        Debug.Assert(DoubleEqual(time1, 100.0 / 3.0));

        double time2 = planners.calculateResponseTime(plan1);
        Debug.Assert(DoubleEqual(time2, 40.0 / 3.0));

        // doba k dokonceni a odezva pro 3. plan
        double time3 = planners.calculateTurnaround(plan3);
        Debug.Assert(time3 == 25);

        double time4 = planners.calculateResponseTime(plan3);
        Debug.Assert(time4 == 5);
    }
}
