using System.Diagnostics;

public class Program
{
    // Tento soubor obsahuje testy pro lokalni testovani
    public static void Main(string[] args)
    {
        SyscallInterface inter = new SyscallInterface();

        // test simple execution and kill
        int pid = inter.Exec("nejaka cesta");
        bool succ = inter.Kill(pid);
        Debug.Assert(succ);

        // test na info neexistujiciho procesu
        var stats = inter.Stats(pid);
        Debug.Assert(stats == null);

        // test na info existujiciho procesu
        string program = "/bin/bash";
        pid = inter.Exec(program);
        stats = inter.Stats(pid);
        Debug.Assert(stats != null);
        Debug.Assert(stats.path == program);
        Debug.Assert(stats.descriptors[0] == "input");
        Debug.Assert(stats.descriptors[1] == "output");
        Debug.Assert(stats.descriptors[2] == "error");

        // test na otevreni souboru neexistujicim procesem
        inter.Kill(pid);
        int fd = inter.Open(pid, "cestaksouboru");
        Debug.Assert(fd == -1);

        // test na realne otevreni souboru
        pid = inter.Exec("cesta");
        var soubor = "mujsoubor";
        fd = inter.Open(pid, soubor);
        Debug.Assert(fd != -1);
        stats = inter.Stats(pid);
        Debug.Assert(stats.descriptors.ContainsKey(fd));

        // zavreni souboru
        succ = inter.Close(pid, fd);
        Debug.Assert(succ);
        stats = inter.Stats(pid);
        stats = inter.Stats(pid);
        Debug.Assert(!stats.descriptors.ContainsKey(fd));
    }
}
