﻿using System.Diagnostics;

class Program
{
    static void Main()
    {
        // testovaci vektory jsou z https://www.rfc-editor.org/rfc/rfc7539#appendix-A
        byte[] key = new byte[32];
        for (int i = 0; i < key.Length; i++)
            key[i] = 0;

        var inst = new ChaCha20(key);

        byte[] nonce = new byte[12];
        for (int i = 0; i < nonce.Length; i++)
            nonce[i] = 0;

        byte[] block = new byte[4];
        for (int i = 0; i < block.Length; i++)
            block[i] = 0;

        var PT = new byte[64];
        for (int i = 0; i < PT.Length; i++)
            PT[i] = 0;

        byte[] expectedCT = {
            0x76, 0xb8, 0xe0, 0xad, 0xa0, 0xf1, 0x3d, 0x90, 0x40, 0x5d, 0x6a, 0xe5, 0x53, 0x86, 0xbd, 0x28,
            0xbd, 0xd2, 0x19, 0xb8, 0xa0, 0x8d, 0xed, 0x1a, 0xa8, 0x36, 0xef, 0xcc, 0x8b, 0x77, 0x0d, 0xc7,
            0xda, 0x41, 0x59, 0x7c, 0x51, 0x57, 0x48, 0x8d, 0x77, 0x24, 0xe0, 0x3f, 0xb8, 0xd8, 0x4a, 0x37,
            0x6a, 0x43, 0xb8, 0xf4, 0x15, 0x18, 0xa1, 0x1c, 0xc3, 0x87, 0xb6, 0x69, 0xb2, 0xee, 0x65, 0x86
        };

        Debug.Assert(inst.EncryptBlock(PT, nonce, block).SequenceEqual(expectedCT));
    }
}
